/**********************************************************************
*
* busybox uevent.c -- Version 3.0 
*
* Copyright (c)
* Apple Computer, Inc.  1986-1990
* All Rights Reserved.
*
* Developer Technical Support Apple II Sample Code
*
* This file contains the code which implements the 
* main event loop used by the busybox program.
*
**********************************************************************/

#include <types.h>
#include <locator.h>
#include <quickdraw.h>
#include <event.h>
#include <menu.h>
#include <window.h>
#include "busybox.h"

extern WmTaskRec        event;
extern unsigned int     quitFlag;

static GrafPortPtr  lastWindow;         /* This private global is used in checkFrontW()
                                        ** to prevent extra work when the windows
                                        ** have not changed.  It is initialized
                                        ** at the beginning of mainEvent().
                                        */

/**********************************************************************
*
* doControls
*
* This procedure is called when an inControl message is returned
* by TaskMaster.
*
* When this routine gets control, the ID of the control that was
* hit is in TaskDATA4.  The control handle is in TaskData2 and
* the part code is in taskData 3.
*
**********************************************************************/
void    doControls()
{
    unsigned int    theID;

    theID = event.wmTaskData4;

    if ((ButButtonsID <= theID) && (theID <= Prog6ID)) {
        openThisWindow(theID);
    }
}



/**********************************************************************
*
* checkFrontW
*
* This routine checks the front window to see if any changes need
* to be made to the menu items.
*
* We do this so that the edit items are only active when a desk
* accessory is active.
*
**********************************************************************/
void    checkFrontW()
{
    GrafPortPtr     theWindow;

    theWindow = FrontWindow();
        /* Get the front window into local storage.*/
    
    if (theWindow == lastWindow) return;
        /* If the lastWindow is this window, we are all set. */
    
    /* If there are no windows, everything should be disabled */
    if (!theWindow) {
        SetMenuFlag(0x0080, EditMenuID);
        DrawMenuBar();
    } 
    else {
        /* Otherwise we look at the window and see what to do. */
        if (GetSysWFlag(theWindow)) { 
            SetMenuFlag (0xFF7F, EditMenuID);       /* Set up for da windows. */
            DrawMenuBar();
        }
        else {
            SetMenuFlag (0x0080, EditMenuID);       /* Set up for our windows. */
            DrawMenuBar();
        }
    }

    lastWindow = theWindow;     /* Remember this for next time. */
}



/**********************************************************************
*
* mainEvent
*
* This is the main part of the program.  The program cycles in this
* loop until the user choose select.
*
**********************************************************************/
void    mainEvent()
{
    unsigned int    code;

    event.wmTaskMask = 0x001FFFFF;          /* Allow TaskMaster to do everything.   */
    quitFlag         = 0;                   /* Done flag will be set by Quit item.  */
    lastWindow       = NULL;                /* Init this for checkFrontW().         */

    for (;;) {
        checkFrontW();
        code = TaskMaster(0xFFFF, &event);
        switch(code) {
            case wInGoAway:
                doCloseTop();
                break;
            case wInSpecial:
            case wInMenuBar:
                doMenu();
                break;
            case wInControl:
                doControls();
                break;
        }
        if (quitFlag) break;
    }
}
